let timer = undefined;
let timeout = 10;

//*********************************************************************************
// W PLAYER API CODE - SETUP
//*********************************************************************************

//Listen in on incoming data 
$wp.setDefaultCallback((object) => {
    switch (object.type) {
        case 'state':
		
            //Call function to perform actions based on CURRENT STATE
			setCallbackByPlayState(object.sub, object.data);
			
            break;
        case 'udp':            
			
            break;
        case 'datalink':
            
            break;
        default:
            break;
    }
});


function setCallbackByPlayState(state, data) {
    switch (state) {
        case 'ready':
		
			//In order to receive a keydown event from a remote controller or keyboard, we need to place focus on the foreground window            
            window.focus();
			
			//Add an event listener to Image1 on Page2 waiting for a user click 
			$wp.content.getPage("Page2").getElement("Image1").addEventListener("click", showDefaultContent);
			
			break;            
        case 'play':
		
			break;               
        case 'stop':
            
            break;
        default:
            break;
    }
}

function showDefaultContent() {
    
	//Reset the timer
    if (timer) {
		
        clearTimeout(timer);
        timer = null;
		
    }

    //Move to the Page1 after the timer expires
    timer = setTimeout(() => {
		
        $wp.content.movePage("Page1");}, timeout * 1000);
}

//*********************************************************************************
// W PLAYER API CODE - USER FUNCTIONS
//*********************************************************************************



//*********************************************************************************
// JS CODE
//*********************************************************************************

window.onload = function () {
	//Setup anything you want to run immediately after the page has loaded (optional)	
}